

/*	:============================================================================================================:
	|	CDS_Constants.inc by Bruce Peaslee                                                                        |
	|	 2012 Campanile Data Systems - All Rights Reserved                                                       |
	|------------------------------------------------------------------------------------------------------------|
	|	Last update:  July 22, 2012                                                                               |
	|------------------------------------------------------------------------------------------------------------|
	|	The purpose of this file is to provide Windows constants that conceivable will be used in all projects.  |
	|	Constants, typedefs, etc., unique to a project are in their own file.                                     |
	:============================================================================================================:
*/


$IFNDEF CDS_CONSTANTS
$DEFINE CDS_CONSTANTS

' Most constants and definitions will be in Sapero's WindowsSDK.inc. CDS_Constants.inc includes that are not.
$IFNDEF WINDOWS_SDK
$INCLUDE "WindowsSDK.inc"
$DEFINE WINDOWS_SDK
$ENDIF

TYPEDEF bool INT

' RGB Colors
Const Red       = 0x0000FF
Const White     = 0xFFFFFF
Const Green     = 0x00FF00
Const Blue      = 0xFF0000
Const Black     = 0x000000
Const Yellow    = 0x00FFFF
Const Orange    = 0x007FFF
Const Maroon    = 0x410581
Const LtGray    = 0xDADADA /* CDS light gray */
Const Chocolate = 0xD2691E

'	Menu Enabled Constants
Const ENABLED  = 0
Const DISABLED = 1

'	Checkbox constants
Const CHECKED   = 1
Const UNCHECKED = 0

'	RichEditConstants [CDS]
Const BOLD = 1

'	Scrollbar constants
Const HORIZ = -1
Const VERT  = -2

'	ListView Constants
Const LVIF_STATE =                   0x0008
Const LVIS_FOCUSED =                 0x0001
Const LVIS_SELECTED =                0x0002
Const LVM_ENSUREVISIBLE =            0x1013
Const LVM_FIRST =                    0x1000
Const LVM_SETBKCOLOR =               0x1001
Const LVM_SETITEMSTATE =             0x102B
Const LVM_SETOUTLINECOLOR =          0x10B1
Const LVM_SETTEXTBKCOLOR =           0x1026
Const LVM_SETTEXTCOLOR =             0x1024
Const LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036
Const LVM_GETNEXTITEM =              0x100C
Const LVN_FIRST =                    0
Const LVN_ITEMACTIVATE =             0xFFFFFF8E
Const LVN_ITEMCHANGED =              0xFFFFFF9B
Const LVN_ITEMCHANGING =             (LVN_FIRST-0)
Const LVNI_SELECTED =                0x0002
Const LVSCW_AUTOSIZE_USEHEADER =     -2
Const LVS_REPORT =                   0x0001
Const LVS_SHOWSELALWAYS =            0x8	
Const LVS_NOLABELWRAP =              0x80
Const LVS_NOSORTHEADER =             0x8000
Const LVS_SINGLESEL =                0x4
Const LVS_EX_FLATSB =                0x0100
Const LVS_EX_FULLROWSELECT =         0x0020
Const LVS_EX_GRIDLINES =             0x0001
Const LVS_EX_LABELTIP =              0x4000
Const LVS_EX_ONECLICKACTIVATE =	    0x0040
Const LVS_EX_TWOCLICKACTIVATE =      0x80

CONST MCM_FIRST			=		0x1000
CONST MCM_GETCURSEL		=		(MCM_FIRST+1)
CONST MCM_SETCURSEL		=		(MCM_FIRST+2)

CONST WM_USER		    	= 0x400	
CONST ECM_FIRST         = 0x1500
CONST EM_SETCUEBANNER   = (ECM_FIRST + 1)
CONST EM_SETBKGNDCOLOR	= (WM_USER+67)

'Notification Messages for Common Controls
Const NM_FIRST     = 0
Const NM_KILLFOCUS = (NM_FIRST-8)	

'ToolBar Constants
Const TB_DELETEBUTTON =	(WM_USER+22)	
Const TB_HIDEBUTTON   =	(WM_USER+4)	

Type NMLISTVIEW 
  NMHDR  hdr
  int    iItem
  int    iSubItem
  UINT   uNewState
  UINT   uOldState
  UINT   uChanged
  POINT  ptAction
  UINT lParam
EndType

Type NMITEMACTIVATE
  uint   hdr
  int    iItem
  int    iSubItem
  UINT   uNewState
  UINT   uOldState
  UINT   uChanged
  POINT  ptAction
  UINT   lParam
  UINT   uKeyFlags
EndType

'	API Declaraions
Declare Import, InitCommonControls()

$ENDIF
